/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.wind;

import it.unimi.dsi.fastutil.bytes.Byte2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectMap;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.ChunkPos;
import tictim.paraglider.wind.WindNode;

public final class WindChunk {
    private final ChunkPos chunkPos;
    private final Byte2ObjectMap<WindNode> nodes = new Byte2ObjectLinkedOpenHashMap();

    public WindChunk(ChunkPos chunkPos) {
        this.chunkPos = Objects.requireNonNull(chunkPos);
    }

    public WindChunk(PacketBuffer buf) {
        this.chunkPos = new ChunkPos(buf.readInt(), buf.readInt());
        for (int i = buf.readUnsignedByte(); i > 0; --i) {
            this.putNode(new WindNode(buf, buf.readUnsignedByte()));
        }
    }

    public ChunkPos getChunkPos() {
        return this.chunkPos;
    }

    @Nullable
    public WindNode getNode(int x, int z) {
        return (WindNode)this.nodes.get(this.encode(x, z));
    }

    @Nullable
    public WindNode putNode(WindNode node) {
        return (WindNode)this.nodes.put(this.encode(node.x, node.z), (Object)node);
    }

    @Nullable
    public WindNode removeAllNodesInXZ(int x, int z) {
        return (WindNode)this.nodes.remove(this.encode(x, z));
    }

    public Collection<WindNode> getAllRootNodes() {
        return this.nodes.values();
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    private byte encode(int x, int z) {
        return (byte)(x << 4 & 0xF0 | z & 0xF);
    }

    public boolean isInsideWind(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        if (this.chunkPos.func_180334_c() > maxX || this.chunkPos.func_180332_e() < minX || this.chunkPos.func_180333_d() > maxZ || this.chunkPos.func_180330_f() < minZ) {
            return false;
        }
        int xs = Math.max(this.chunkPos.func_180334_c(), minX);
        int xe = Math.min(this.chunkPos.func_180332_e(), maxX);
        int zs = Math.max(this.chunkPos.func_180333_d(), minZ);
        int ze = Math.min(this.chunkPos.func_180330_f(), maxZ);
        for (int x = xs; x <= xe; ++x) {
            for (int z = zs; z <= ze; ++z) {
                WindNode node = this.getNode(x, z);
                while (node != null) {
                    if (node.y < maxY && node.y + node.height > minY) {
                        return true;
                    }
                    node = node.next;
                }
            }
        }
        return false;
    }

    public boolean add(int x, int y, int z, int height, long gameTime) {
        WindNode node = this.getNode(x, z);
        if (node != null) {
            return node.overwrite(y, height, gameTime);
        }
        this.putNode(new WindNode(x, y, z, height, gameTime));
        return true;
    }

    public void write(PacketBuffer buf) {
        buf.writeInt(this.chunkPos.field_77276_a);
        buf.writeInt(this.chunkPos.field_77275_b);
        buf.func_150787_b(this.nodes.size());
        for (Byte2ObjectMap.Entry e : this.nodes.byte2ObjectEntrySet()) {
            ((WindNode)e.getValue()).write(buf);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WindChunk windChunk = (WindChunk)o;
        return this.chunkPos.equals((Object)windChunk.chunkPos);
    }

    public int hashCode() {
        return this.chunkPos.hashCode();
    }
}

